!...THIS PROGRAM WILL DISPLAY SHIP TRACKS AND BEARINGS TO WHALE ACOUSTIC DETECTIONS
!...COMPILE USING INTEL VISUAL FORTRAN V. 8.0 (REQUIRES MICROSOFT VISUAL C++ .NET STUDIO)
!...REQUIRED FILES:     WHALTRAK.INP (SETUP PARAMETERS)
!
!...OUTPUT FILE NUMBERS:
!       12  GPS ERROR/DIAGNOSTICS FILE
!       13  TRAK FILE
!       14  BAK BACKUP FILE FOR TRAK
!       15  LOG POSITION FILE
!
!...VERSION 2.1 BY JAY BARLOW  (MARCH 2005)
!      
   PROGRAM WHALTRAK
	USE MSFLIB
	USE IFPORT
	USE GRAFTRAK	
	
   IMPLICIT NONE
   CHARACTER   ASTRING*120
   EXTERNAL    MOUSELEFTCK, MOUSERIGHTCK
   LOGICAL     SIMULATE,QUIT,statusmode
   INTEGER*4   I4, JMIN, JSEC, KSEC, ITER, IPORTgps, IPORTish, IBAUD, GPSDIAGNOSTICS
   REAL*8      STIME
   CHARACTER   GPS*3, GPSFORMAT*40
!...DEFINE QUIKWIN VARIABLES
   TYPE (qwinfo) winfo
   TYPE (windowconfig) wc
   ISEQ= 0
!version info
!
    ISTAT = ABOUTBOXQQ ('WHALTRAK version 2.0 by Jay Barlow, SWFSC'C)      
!
!
!...SET GRAPHICS MODE TO 600 X 800 RESOLUTION
	wc.numxpixels = -1   !800
	wc.numypixels = -1   !600
	wc.numtextcols = -1
	wc.numtextrows = -1
	wc.numcolors = -1
	wc.title = "Whale Acoustic Tracking"C
	wc.fontsize = #0008000F     ! 8 X 15 
	statusmode = SETWINDOWCONFIG(wc)
	IF (.NOT. statusmode) statusmode = SETWINDOWCONFIG(wc)
!
!...SET OUTER WINDOW TO MAXIMUM SIZE
	winfo.TYPE= QWIN$MAX
	ISTAT= SETWSIZEQQ(QWIN$FRAMEWINDOW,winfo)
!
!...SET PRIMARY WINDOW TO MAXIMUM SIZE
	winfo.TYPE= QWIN$SET
    winfo.x= 0
    winfo.y= 0
    winfo.h= 43   
    winfo.w=144    
    ISTAT= SETWSIZEQQ(0,winfo)       
!
!...SET CHILD WINDOW PARAMETERS FOR DATA INPUT
    winfo2.TYPE= QWIN$SET
    winfo2.x= 60
    winfo2.y= 36
    winfo2.h= 4
    winfo2.w=60
    ISTAT= SETWSIZEQQ(20,winfo2)
!
!...SET PROTOCOL FOR MOUSE BUTTON 
   OPEN (UNIT= 0, FILE= 'USER')        
   I4= REGISTERMOUSEEVENT(0,MOUSE$LBUTTONDOWN,MOUSELEFTCK)
   I4= REGISTERMOUSEEVENT(0,MOUSE$RBUTTONDOWN,MOUSERIGHTCK)
   I4= REGISTERMOUSEEVENT(0,MOUSE$LBUTTONDBLCLK,MOUSELEFTCK)
   I4= REGISTERMOUSEEVENT(0,MOUSE$RBUTTONDBLCLK,MOUSERIGHTCK)
!
!...READ INPUT PARAMETERS
	OPEN (UNIT=11, FILE='WHALTRAK2.INP')
	READ (11,*) IPORTish                       !COM PORT TO RECEIVE BEARINGS FROM ISHMAEL
	READ (11,*) IPORTgps                       !COM PORT TO RECEIVE GPS INFO
	READ (11,*) MSEC
	READ (11,*) MMIN
	READ (11,*) REDTIME
	READ (11,*) DEADTIME
	READ (11,*) DISTARAY
	READ (11,'(A3)') GPS
	READ (11,*) GPSFORMAT
    READ (11,*) GPSDIAGNOSTICS
	READ (11,*) SIMULATE, SPEED
	READ (11,*) REPLAY
!
!   CONVERT FROM METERS TO NMI
    DISTARAY= DISTARAY / 1853.0
!
! DIAGNOSTIC PRINT OUTPUT
	OPEN (UNIT=12, FILE='GPS.ERR')
	WRITE (12,'(I2,1X,A3,3X,A40)') IPORTgps, GPS,GPSFORMAT
!
!...OPEN SERIAL PORTS USING INTEL FORTRAN ROUTINES
   IF (.NOT. REPLAY) THEN
      CALL OPEN_COMPORT(.TRUE.,IPORTish,9600)
      IF (.NOT. SIMULATE) CALL OPEN_COMPORT(.TRUE.,IPORTgps,4800)
   ENDIF
!
!...SET TURQUOISE BACKGROUND COLOR AND BLACK TEXT COLOR
   ISTAT= SETBKCOLOR(15)            ! WHITE
   ISTAT= SETTEXTCOLOR(0)           ! BLACK
!
!...OPEN OUTPUT FILES WITH TIME/DATE STAMP OR OPEN INPUT FILE FOR PLAY BACK MODE
   IF (.NOT. REPLAY) THEN
      CALL OPENFILE()
   ENDIF
!
!...SET INITIAL PARAMETERS,  INITIAL PLOT SPACE WILL BE 20NMI X 20NMI
   SCALE= 10.0/60.0     ! SCALE IS THE HALF THE VERTICAL DISTANCE, IN DEGREES
   ICONSIZE= SCALE/20.0
   DOTSIZE= SCALE/100.0
   QUIT= .FALSE.
   LCLICK= .FALSE.
   RCLICK= .FALSE.
   TURNING= .TRUE.
   NDETECT= 0
   IMIN= 1
   JTIME= 1
   NWHALES= 0
!
!...GET INITIAL LAT/LONG
   IF (SIMULATE) THEN 
      LASTLAT= 0.00
      LASTLONG= 0.00
      LATXX(JTIME)= 0.0
      LONGXX(JTIME)= 0.0
	  TIMEXX(JTIME)= 0
      CALL GETTIM(IHR,IMIN,ISEC,I100TH)
      CALL GETDAT(IYR,IMO,IDA) 
      CALL PACKTIMEQQ(JTIMEZERO,IYR,IMO,IDA,IHR,IMIN,ISEC)
      SIMHEAD= 360.0                         !HEADING DUE NORTH                 
      SIMDIST= SPEED / (60.0 * 60.0)         !DISTANCE TRAVELED PER SECOND
   ELSE IF (REPLAY) THEN
      CALL GETREPLAY()
      LASTLAT= LATXX(JTIME)
      LASTLONG= LONGXX(JTIME)
   ELSE
      CALL GETLATLONGXX(RLAT,RLONG,GPS,GPSFORMAT,GPSDIAGNOSTICS,IPORTgps)
      ITER= 1
!...IF INVALID LAT/LONG, WAIT FIVE SECONDS AND TRY AGAIN
      DO WHILE ((RLAT .EQ. 0.0).AND.(RLONG .EQ. 0.0))
         CALL GETTIM(IHR,IMIN,ISEC,I100TH)
         IF ((ISEC .NE. JSEC).AND.(MOD(ISEC,5) .EQ. 0)) THEN
            JSEC= ISEC
            WRITE (0,*) 'INVALID GPS POSITION'
            ITER=ITER + 1
            IF (ITER .GT. 10) STOP
			CALL GETLATLONGXX(RLAT,RLONG,GPS,GPSFORMAT,GPSDIAGNOSTICS,IPORTgps)
		 ENDIF
      END DO
      LASTLAT= RLAT
      LASTLONG= RLONG
      LATXX(JTIME)= RLAT
      LONGXX(JTIME)= RLONG
         CALL GETTIM(IHR,IMIN,ISEC,I100TH)
         CALL GETDAT(IYR,IMO,IDA) 
		 CALL PACKTIMEQQ(JTIMEZERO,IYR,IMO,IDA,IHR,IMIN,ISEC)
	  TIMEXX(JTIME)= JTIMEZERO
      ASTRING= 'WHALTRAK2:  THIS IS THE FIRST POSITION'
      CALL DATAOUT(13,'B',ASTRING)
      CALL DATAOUT(15,'B',ASTRING)
   ENDIF
   CALL REDRAW()           !REDRAW PLOT SPACE
!
!...BEGIN ENDLESS LOOP WAITING FOR EVENT-DRIVEN INPUT
   ICHECK= 5
   DO WHILE (.NOT. QUIT)
!...CHECK EVERY ICHECK SECONDS TO SEE IF NEW POSITION IS AVAILABLE FROM THE SERIAL PORT
      CALL GETTIM(IHR,IMIN,ISEC,I100TH)
      IF ((ISEC .NE. JSEC).AND.(MOD(ISEC,ICHECK) .EQ. 0)) THEN
         JSEC= ISEC
!...FOR SIMULATED POSITION, CALCULATE CHANGE IN LOCATION FOR GIVEN SIMULATED SPEED AND HEADING
         IF (SIMULATE) THEN
			HEADING= SIMHEAD
			DIST= SIMDIST * ICHECK
            CALL GREATCIRCLE(LASTLAT,LASTLONG,RLAT,RLONG,HEADING,DIST)
!...FOR REAL-TIME MODE, CHECK SERIAL PORT FOR NEW LAT/LONG.
         ELSE IF (.NOT. REPLAY) THEN
            CALL GETLATLONGXX(RLAT,RLONG,GPS,GPSFORMAT,GPSDIAGNOSTICS,IPORTgps)
         ENDIF
         IF ((RLAT .NE. 0.0).OR.(RLONG .NE. 0.0)) THEN
            PREVLAT= LASTLAT
            PREVLONG= LASTLONG                  
            LASTLAT= RLAT
            LASTLONG= RLONG
            CALL GETTIM(IHR,IMIN,ISEC,I100TH)
            CALL GETDAT(IYR,IMO,IDA) 
	        CALL PACKTIMEQQ(LASTTIME,IYR,IMO,IDA,IHR,IMIN,ISEC)
         ENDIF
      ENDIF
!...RE-PLOT POSITION AND CALCULATE HEADING EVERY MSEC SECONDS
      IF ((ISEC .NE. KSEC).AND.(MOD(ISEC,MSEC) .EQ. 0)) THEN
         KSEC= ISEC
         JTIME= JTIME + 1
         LATXX(JTIME)= LASTLAT
         LONGXX(JTIME)= LASTLONG
	     TIMEXX(JTIME)= LASTTIME - JTIMEZERO
!...CALCULATE A NEW HEADING FROM PREVIOUS LAT/LONG (UPDATING FASTER DURING TURNS)
         IF ((TURNING).AND.(JTIME .GT. 1)) THEN
            TURNING= .FALSE.
            PREVLAT= LATXX(JTIME-1)
            PREVLONG= LONGXX(JTIME-1)
            STIME= TIMEXX(JTIME-1)
         ELSE IF (JTIME .GT. 3) THEN
            PREVLAT= LATXX(JTIME-3)
            PREVLONG= LONGXX(JTIME-3)
            STIME= TIMEXX(JTIME-3)
         ENDIF
         IF ((LASTLAT .NE. PREVLAT).AND.(LASTLONG .NE. PREVLONG)) THEN
            IF (.NOT. SIMULATE) THEN
               HEADING= -1.0
               CALL GREATCIRCLE(PREVLAT,PREVLONG,LASTLAT,LASTLONG,HEADING,DIST)
               IF (JTIME .GT. 3) SPEED= DIST / ((TIMEXX(JTIME)-STIME)/(60.0*60.0))
               IF (ABS(HEADING-OLDHEADING) .GT. 5) TURNING= .TRUE.  !AUTOMATIC DETECTION OF TURNS
               OLDHEADING= HEADING
            ENDIF
         ENDIF
!...RE-DRAW PLOT SPACE 
         CALL REDRAW()        !REDRAW PLOT SPACE
!...WRITE POSITION TO LOG FILE
         WRITE (ASTRING,'(15X,F5.0,F5.1)') HEADING,SPEED
         IF (.NOT. REPLAY) CALL DATAOUT(15,'*',ASTRING)
      ENDIF
!...WRITE NEW POSITION TO FILE EVERY MMIN MINUTES (or every minute if turning)
      IF (IMIN .NE. JMIN) THEN
		 JMIN= IMIN
         IF ((MOD(IMIN,MMIN) .EQ. 0).OR.(TURNING)) THEN
            WRITE (ASTRING,'(15X,F5.0,F5.1)') HEADING,SPEED
            IF (.NOT. REPLAY) CALL DATAOUT(13,'*',ASTRING)
         ENDIF
      ENDIF
!...CHECK FOR KEYBOARD INPUT (NOTE, PEEKCHARQQ DOES NOT WORK WITH QWIKWIN PROGRAMS)
!      KEYREADY= PEEKCHARQQ()
!      WRITE (0,*) KEYREADY
!      IF (KEYREADY) THEN
!         CALL GETAKEY()
!         CALL REDRAW()
!      ENDIF
!
!...CHECK FOR MOUSE INPUT
      IF (LCLICK) THEN
         LCLICK= .FALSE.
         CALL LEFTCLICK()
      ELSE IF (RCLICK) THEN
         RCLICK= .FALSE.
         CALL RIGHTCLICK()
      ENDIF
!
!...CHECK FOR NEW WHALE BEARING FROM SERIAL PORT ish
      IF (.NOT. REPLAY) THEN
         WHALBEAR= -999.0
         CALL GETBEARING(WHALBEAR,IPORTish)
         IF (WHALBEAR .NE. -999.0) THEN
            CALL PLOT_NEW_BEARING()
		    WRITE (ASTRING,'(F5.1)') WHALBEAR
            CALL DATAOUT(13,'D',ASTRING)
         ENDIF
      ENDIF
!
   END DO
!...CLOSE COM PORTS AND END PROGRAM
   CALL OPEN_COMPORT(.FALSE.,IPORTgps,IBAUD)
   CALL OPEN_COMPORT(.FALSE.,IPORTish,IBAUD)
   STOP
   END

!.........................................................................................
!...ADD A NEW BEARING ANGLE TO BE PLOTTED
    SUBROUTINE PLOT_NEW_BEARING()
    USE GRAFTRAK
    IMPLICIT NONE
    REAL*8  DELTATIME
    INTEGER*4 IDELTA
       NDETECT= NDETECT + 1
!...PLOT BEARING LINES FROM POSITIONS COLLECTED EARLIER, WHEN SHIP WAS AT CURRENT ARRAY LOCATION.
       IF ((SPEED .LT. 1.0).OR.(SPEED .GT. 13.0)) SPEED= 10.0
       DELTATIME= (DISTARAY / SPEED) * (60.0*60.0)
       DO IDELTA= (JTIME-1),1,-1
!           WRITE (12,*) 'IDELTA=',IDELTA,'JTIME=',JTIME,'TIMEXX(JTIME)=',TIMEXX(JTIME),  &
!              'TIMEXX(IDELTA)=',TIMEXX(IDELTA)
		   IF ((TIMEXX(JTIME)-TIMEXX(IDELTA)) .GT. DELTATIME) GOTO 800
       ENDDO
 800   CONTINUE
       IF (IDELTA .LE. 0) IDELTA= 1
       XLATXX(NDETECT)= LATXX(IDELTA)
       XLONGXX(NDETECT)= LONGXX(IDELTA)
       XTIMEXX(NDETECT)= (IHR*60) + IMIN
       XBEAR1(NDETECT)= HEADING - WHALBEAR
       IF (XBEAR1(NDETECT) .LT. 0.0) XBEAR1(NDETECT)= XBEAR1(NDETECT) + 360.0
       XBEAR2(NDETECT)= HEADING + WHALBEAR
       IF (XBEAR2(NDETECT) .GT. 360.0) XBEAR2(NDETECT)= XBEAR2(NDETECT) - 360.0
	   CALL REDRAW()
    RETURN
    ENDSUBROUTINE


!.........................................................................................
!...OPEN COMM PORT USING INTEL COMMS LIBRARY (OR CLOSE PORT IF OPENYN IS FALSE)
   SUBROUTINE OPEN_COMPORT(OPENYN,IPORT,BAUD)
   USE IFPORT
   IMPLICIT NONE
   LOGICAL OPENYN
   INTEGER*4 IPORT,BAUD,PARITY,STPBTS,BITS,IORESULT
!
   IF (IPORT .GT. 4) THEN
	  WRITE (0,*) 'WARNING: COM PORTS GREATER THAN 4 HAVE NOT BEEN TESTED.'
	  WRITE (0,*) '    HIT ENTER TO TRY.  GOOD LUCK.'
      PAUSE 123
   ENDIF
   IF (OPENYN) THEN
      PARITY = 0            !NO PARITY
      STPBTS = 0            !ONE STOP BIT
      BITS=8                !8 BITS PER CHARACTER
      IORESULT= SPORT_CONNECT(IPORT)
      IF (IORESULT .NE. 0) THEN
        WRITE (0,*) ' ERROR OPENING COM PORT:',IPORT
        PAUSE
      ENDIF      
      IORESULT= SPORT_CANCEL_IO(IPORT)+SPORT_SET_STATE(IPORT,BAUD,PARITY,BITS,STPBTS)
      IF (IORESULT .NE. 0) THEN
        WRITE (0,*) ' ERROR SETTING UP COM PORT:',IPORT
        PAUSE
      ENDIF      
   ELSE
      IORESULT= SPORT_RELEASE(IPORT)
   ENDIF
   RETURN
   END


!.........................................................................................
!...FLUSH COM PORT USING INTEL COMMS LIBRARY (TO AVOID BUFFER OVERFLOW)
   SUBROUTINE FLUSHCOMPORT(PORT)
   USE IFPORT
   USE IFWINTY
   IMPLICIT NONE
   CHARACTER*4 PORT
   INTEGER*4 IORESULT,IPORT
      IORESULT = SPORT_PURGE(IPORT, (PURGE_TXABORT .or. PURGE_RXABORT) )
   RETURN
   END

!.........................................................................................
!...READ CHARACTERS FROM SERIAL gpsPORT BUFFER AND LOOK FOR VALID GPS STRING
!...IF VALID STRING IS FOUND, CONVERT DATA TO FLOATING POINT LATITUDE AND LONGITUDE
!...WHERE SOUTH LATITUDES AND WEST LONGITUDES ARE NEGATIVE.
   SUBROUTINE  GETLATLONGXX(RLAT,RLONG,GPS,GPSFORMAT,GPSDIAGNOSTICS,PORT)
   USE MSFLIB
   USE IFPORT
   IMPLICIT NONE
   REAL*8 RLAT, RLONG, RLATM, RLONGM
   CHARACTER*1 NORS, EORW
   CHARACTER GPS*3, GPSFORMAT*40
   INTEGER*4 PORT, AVAIL_DATA, IORESULT
   CHARACTER  MESSAGE*40, BUFFER*1024
   INTEGER*4 :: BUFFSIZE=1024, NBYTES, ILATD, ILONGD
   LOGICAL GPSDIAGNOSTICS
!
   AVAIL_DATA= 0
   IORESULT= SPORT_PEEK_LINE(PORT,AVAIL_DATA,NBYTES)
   IF (AVAIL_DATA) THEN
      IORESULT= SPORT_READ_LINE(PORT,BUFFER,NBYTES)
      IF (GPSDIAGNOSTICS) WRITE(12,'(A)') BUFFER(1:NBYTES)       !DIAGNOSTIC MESSAGE
   ELSE
      RETURN
   ENDIF

   DO WHILE ((AVAIL_DATA).AND.(IORESULT.EQ.0))
      IF (BUFFER(4:6) .EQ. GPS) THEN
         IF (NBYTES .GT. 47) NBYTES= 47
         MESSAGE= BUFFER(8:NBYTES)
         IF (GPSDIAGNOSTICS) WRITE (12,'(A)') MESSAGE
         READ (MESSAGE,GPSFORMAT,ERR=999) ILATD,RLATM,NORS,ILONGD,RLONGM,EORW
         IF ((EORW .EQ. 'E').OR.(EORW .EQ. 'W')) THEN
            RLAT= ILATD + RLATM/60.0
            RLONG= ILONGD + RLONGM/60.0
            IF (NORS .EQ. 'S') RLAT= -RLAT
            IF (EORW .EQ. 'W') RLONG= -RLONG
         ENDIF
      ENDIF
      AVAIL_DATA= 0
      IORESULT= SPORT_PEEK_LINE(PORT,AVAIL_DATA,NBYTES)
      NBYTES= 0
      IF (AVAIL_DATA) THEN
         IORESULT= SPORT_READ_LINE(PORT,BUFFER,NBYTES)
         IF (GPSDIAGNOSTICS) WRITE(12,'(A)') BUFFER(1:NBYTES)       !DIAGNOSTIC MESSAGE
      ENDIF
   ENDDO
 999 CONTINUE
   RETURN
   END

!.........................................................................................
!...READ CHARACTERS FROM SERIAL PORT BUFFER AND LOOK FOR VALID BEARING ANGLE
!...IF VALID BEARING IS FOUND, RETURN VALUE FOR PLOTTING
   SUBROUTINE  GETBEARING(WHALBEAR,IPORT)
   USE MSFLIB
   USE IFPORT
   IMPLICIT NONE
   CHARACTER BUFFER*10, ABYTE*1
   CHARACTER MESSAGE*10
   INTEGER*4 ::  BUFFSIZE=10, IPORT, IORESULT, AVAIL_DATA, NBYTES, I, J, IERR
   REAL*8 WHALBEAR
!
!...CHECK STATUS OF COM1 PORT FOR NEW BEARING DATA AND READ DATA IF PRESENT
   AVAIL_DATA= 0
   IORESULT= SPORT_PEEK_DATA(IPORT,AVAIL_DATA,NBYTES)
   IF (AVAIL_DATA) THEN
      IF (NBYTES .LE. BUFFSIZE) THEN
         IORESULT= SPORT_READ_DATA(IPORT,BUFFER,NBYTES)
         WRITE(12,'(A)') BUFFER(1:NBYTES)       !DIAGNOSTIC MESSAGE
      ELSE
         CALL FLUSHCOMPORT(IPORT)
         RETURN
      ENDIF
   ELSE
      RETURN
   ENDIF
!
!...GET CHARACTERS FROM RECEIVE BUFFER UNTIL '$' IS RECEIVED THEN READ CHARACTERS UP TO '#'
   DO I=1,NBYTES
      IF (BUFFER(I:I) .EQ. '$') THEN
         DO J=I+2,NBYTES
            IF (BUFFER(J:J) .EQ. '#') THEN
               MESSAGE= BUFFER(I+1:J-1)
               WRITE (12,*) MESSAGE                       !DIAGNOSTIC PRINT
               READ (MESSAGE,*,IOSTAT=IERR) WHALBEAR
               WRITE (12,*) WHALBEAR                      !DIAGNOSTIC PRINT
               IF (IERR .NE. 0) WHALBEAR= -999.0
               RETURN
            ENDIF
         ENDDO
      ENDIF
   ENDDO
   RETURN
   END

  
!.........................................................................................
!...LAND HERE FIRST IF LEFT MOUSE CLICK
   SUBROUTINE MOUSELEFTCK(iunit, ievent, ikeystate, ixpos, iypos)
	USE MSFLIB
	USE GRAFTRAK
   INTEGER*4 iunit, ievent, ikeystate, ixpos, iypos
      LCLICK= .TRUE.
      IXMOUSE= IXPOS
      IYMOUSE= IYPOS
      IF (INPUT_PENDING)ISTAT= FOCUSQQ(20)    !SET FOCUS ON DATA INPUT WINDOW, IF PRESENT
   RETURN
   END SUBROUTINE

!.........................................................................................
!...LAND HERE FIRST IF RIGHT MOUSE CLICK
   SUBROUTINE MOUSERIGHTCK(iunit, ievent, ikeystate, ixpos, iypos)
	USE MSFLIB
	USE GRAFTRAK
   INTEGER*4 iunit, ievent, ikeystate, ixpos, iypos
      RCLICK= .TRUE.
      IXMOUSE= IXPOS
      IYMOUSE= IYPOS
      IF (INPUT_PENDING)ISTAT= FOCUSQQ(20)    !SET FOCUS ON DATA INPUT WINDOW, IF PRESENT
   RETURN
   END SUBROUTINE

!.........................................................................................
!...GO HERE IF LEFT MOUSE CLICK
   SUBROUTINE LEFTCLICK()
	USE MSFLIB
	USE GRAFTRAK
   IMPLICIT NONE
   INTEGER*4 ILATD, ILONGD
   REAL*8 RLATM, RLONGM
   CHARACTER ASTRING*120
   TYPE (wxycoord) wt
   IF (IXMOUSE .LT. 20) THEN
      IF (IYMOUSE .LE. 20) THEN                                 !INCREASE SCALE
         SCALE= SCALE * 2.0
      ELSE IF (IYMOUSE.LE. 40) THEN                             !DECREASE SCALE
         SCALE= SCALE / 2.0
      ELSE IF ((IYMOUSE .LT. 90).AND.(IYMOUSE .GE. 60)) THEN    !INDICATE TURNING
        TURNING= .TRUE.                           
        ASTRING= '' 
        IF (.NOT. REPLAY) CALL DATAOUT(13,'T',ASTRING)
      ELSE IF ((IYMOUSE .LT. 120).AND.(IYMOUSE .GE. 90)) THEN   !GET H-PHONE SPACING
         CALL GET_HPSPACE()
         IF (HPDIST .GT. 0) THEN
            WRITE (HPHONE_DIST,'(F5.1)') HPDIST
            WRITE (ASTRING,'(F5.1)') HPDIST
            IF (.NOT. REPLAY) CALL DATAOUT(13,'H',ASTRING)
         ENDIF
      ELSE IF ((IYMOUSE .LT. 150).AND.(IYMOUSE .GE. 120)) THEN  !GET COMMENT
         CALL GET_COMMENT()
         WRITE (12,*) ACOMMENT
         ASTRING= ACOMMENT
         IF (.NOT. REPLAY) CALL DATAOUT(13,'C',ASTRING)
      ELSE IF ((IYMOUSE .LT. 180).AND.(IYMOUSE .GE. 150)) THEN  !GET OPERATOR ID
         CALL GET_OPERATOR()
         WRITE (ASTRING,'(A5)') AOPERATOR
         IF (.NOT. REPLAY) CALL DATAOUT(13,'O',ASTRING)
      ELSE IF ((IYMOUSE .LT. 210).AND.(IYMOUSE .GE. 180)) THEN  !CHANGE EFFORT STATUS
         ASTRING= ''
         IF (EFFORT) THEN
            EFFORT= .FALSE.
            IF (.NOT. REPLAY) CALL DATAOUT(13,'E',ASTRING)
         ELSE
            EFFORT= .TRUE.
            IF (.NOT. REPLAY) CALL DATAOUT(13,'R',ASTRING)
         ENDIF
      ELSE IF ((IYMOUSE .LT. 240).AND.(IYMOUSE .GE. 210)) THEN  !GET BEARING FROM KEYBD
         CALL GET_BEARING(WHALBEAR)
         IF (WHALBEAR .GT. 0.0) CALL PLOT_NEW_BEARING()
      ELSE IF ((IYMOUSE .LT. 270).AND.(IYMOUSE .GE. 240)) THEN  !RECORD CLICK INTERVAL
         CALL GET_CLICKINTERVAL()
         IF ((CLICKINTERVAL .GT. 0).AND.(CLICKINTERVAL .LE. 999)) THEN
            WRITE (CLICK_INTERVAL,'(F5.1)') CLICKINTERVAL
            WRITE (ASTRING,'(F5.1)') CLICKINTERVAL
            IF (.NOT. REPLAY) CALL DATAOUT(13,'I',ASTRING)
         ENDIF
      ELSE IF ((IYMOUSE .LT. 300).AND.(IYMOUSE .GE. 270)) THEN  !ERASE OLD LINES
         CALL GET_NEW_DEADTIME()
      ELSE IF ((IYMOUSE .LT. 330).AND.(IYMOUSE .GE. 300)) THEN  !START/END RECORDING   
         CALL GET_START_END_RECORD()
      ELSE IF ((IYMOUSE .LT. 360).AND.(IYMOUSE .GE. 330)) THEN  !TIMED UPDATE
         CALL GET_TIMED_UPDATE()
	  ENDIF
   ELSE 
      CALL GETWINDOWCOORD(IXMOUSE,IYMOUSE,wt)
      IF (wt.wy .GT. 0) THEN
         NORS= 'N'
         ILATD= INT(wt.wy)
         RLATM= (wt.wy - ILATD) * 60.0
      ELSE
         NORS= 'S'
         ILATD= INT(-wt.wy)
         RLATM= -(wt.wy + ILATD) * 60.0
      ENDIF
      IF (wt.wx .GT. 0) THEN
         EORW= 'E'
         ILONGD= INT(wt.wx)
         RLONGM= (wt.wx - ILONGD) * 60.0
      ELSE
         EORW= 'W'
         ILONGD= INT(-wt.wx)
         RLONGM= -(wt.wx + ILONGD) * 60.0
      ENDIF
      WRITE (CURSOR_LAT, '(I5,1H:,F5.2,A1)') ILATD,RLATM,NORS
      WRITE (CURSOR_LONG,'(I5,1H:,F5.2,A1)') ILONGD,RLONGM,EORW
      BEARING= -1
      CALL GREATCIRCLE(LASTLAT,LASTLONG,wt.wy,wt.wx,BEARING,DIST)
      WRITE (CURSOR_BEAR,'(F5.0)') BEARING
      WRITE (CURSOR_DIST,'(F6.2)') DIST
   ENDIF
   CALL REDRAW()
   RETURN
   END SUBROUTINE

!.........................................................................................
!...GO HERE IF LEFT MOUSE CLICK
   SUBROUTINE RIGHTCLICK()
	USE MSFLIB
	USE GRAFTRAK
   IMPLICIT NONE
   INTEGER*4 ILATD, ILONGD
   REAL*8 RLATM, RLONGM
   CHARACTER ASTRING*120
   TYPE (wxycoord) wt
      CALL GETWINDOWCOORD(IXMOUSE,IYMOUSE,wt)
      NWHALES= NWHALES + 1
      WLATXX(NWHALES)= wt.wy
      WLONGXX(NWHALES)= wt.wx
      IF (wt.wy .GT. 0) THEN
         NORS= 'N'
         ILATD= INT(wt.wy)
         RLATM= (wt.wy - ILATD) * 60.0
      ELSE
         NORS= 'S'
         ILATD= INT(-wt.wy)
         RLATM= -(wt.wy + ILATD) * 60.0
      ENDIF
      IF (wt.wx .GT. 0) THEN
         EORW= 'E'
         ILONGD= INT(wt.wx)
         RLONGM= (wt.wx - ILONGD) * 60.0
      ELSE
         EORW= 'W'
         ILONGD= INT(-wt.wx)
         RLONGM= -(wt.wx + ILONGD) * 60.0
      ENDIF
      WRITE (CURSOR_LAT, '(I5,1H:,F5.2,A1)') ILATD,RLATM,NORS
      WRITE (CURSOR_LONG,'(I5,1H:,F5.2,A1)') ILONGD,RLONGM,EORW
      BEARING= -1
      CALL GREATCIRCLE(LASTLAT,LASTLONG,wt.wy,wt.wx,BEARING,DIST)
      WRITE (CURSOR_BEAR,'(F5.0)') BEARING
      WRITE (CURSOR_DIST,'(F6.1)') DIST
      CALL REDRAW()
!...WRITE OUTPUT LINE
      WRITE (ASTRING,'(I5,F5.1,I5,F5.1,F5.0,F5.1)') ILATD,RLATM,ILONGD,RLONGM,BEARING,DIST
      IF (.NOT. REPLAY) CALL DATAOUT(13,'S',ASTRING)
   RETURN
   END SUBROUTINE


!-----------------------------------------------------------------------
   SUBROUTINE GREATCIRCLE(LAT1,LONG1,LAT2,LONG2,BEARING,DISTANCE)
!
!...THIS SUBROUTINE CALCULATES GREAT CIRCLE POSITIONS FROM AN INTIAL POSITION AND 
!     BEARING & DISTANCE, OR (IF BEARING = -1) CALCULATES GREAT CIRCLE BEARING &
!     DISTANCE FROM TWO POSITIONS.
!...NOTE THAT WEST LONGITUDES AND SOUTH LATITUDES ARE NEGATIVE.
   IMPLICIT DOUBLE PRECISION (A-H,O-Z)
   IMPLICIT INTEGER*4 (I-N)
   DOUBLE PRECISION LAT1,LONG1,LAT2,LONG2,BEARING,DISTANCE
	DOUBLE PRECISION COL1,COL2,DELTALAT,DELTALONG,DANGLE
	DOUBLE PRECISION HAVSIND,ANGLE,SECD,COSECD
!
!...SUBROUTINE-SPECIFIC FUNCTIONS:
	      HAVSIND(ANGLE)= (1.0 - COSD(ANGLE))/2.0
	      SECD(ANGLE)= 1.0 / COSD(ANGLE)
	      COSECD(ANGLE)= 1.0 / SIND(ANGLE)

!...CALCULATE BEARING AND DISTANCE FROM LAT1,LONG1 TO LAT2,LONG2
	IF (BEARING .EQ. -1.0) THEN
         COL1= 90.0 - LAT1
	      COL2= 90.0 - LAT2
	      DELTALAT= LAT2 - LAT1
	      DELTALONG= LONG2 - LONG1
         IF (DELTALONG .EQ. 0.0) DELTALONG= 0.00001
	      DANGLE= (HAVSIND(DELTALONG)*COSD(LAT1)*COSD(LAT2)) + HAVSIND(DELTALAT)
	      DANGLE= ACOSD(1.0 - (2.0 * DANGLE))
	      DISTANCE= 21600.0 * DANGLE / 360.0
	      BEARING= ACOSD(1.0 - 2.0*(SECD(LAT1)*COSECD(DANGLE)*    &
                 (HAVSIND(COL2)-HAVSIND(ABS(DANGLE-COL1)))))
         IF (LONG1 .GT. LONG2) BEARING= 360.0 - BEARING
!...CALCULATE NEW POSITION FROM OLD POSITION PLUS BEARING AND DISTANCE
	ELSE
	      IF (DISTANCE .LT. 0.0) BEARING= BEARING - 180.0
	      IF (BEARING .GT. 360.0) THEN
	         BEARING= BEARING - 360.0
	      ELSE IF (BEARING .LT. 0.0) THEN
	         BEARING= BEARING + 360.0
	      ENDIF
	      COL1= 90.0 - LAT1
	      DANGLE= DISTANCE/60.0
	      TEMP= HAVSIND(ABS(DANGLE-COL1)) +     &
                 HAVSIND(BEARING)/(SECD(LAT1)*COSECD(DANGLE)) 
	      COL2= ACOSD(1.0 - 2.0 * TEMP)
	      LAT2= 90.0 - COL2
	      DELTALAT= ABS(LAT2-LAT1)
	      TEMP= (HAVSIND(DANGLE) - HAVSIND(DELTALAT)) / (COSD(LAT1) * COSD(LAT2))
	      DELTALONG= ACOSD(1.0 - 2.0 * TEMP)
	      IF (BEARING .GT. 180.0) THEN
	            LONG2= LONG1 - DELTALONG
	      ELSE
	            LONG2= LONG1 + DELTALONG
	      ENDIF
	      IF (LONG2 .GT. 180) LONG2= LONG2 - 360.0
     	ENDIF
	RETURN
	END

!____________________________________________________________________________________
!...OPEN FILE WITH TIME/DATE STAMP
   SUBROUTINE OPENFILE()
	USE MSFLIB
	USE GRAFTRAK
   IMPLICIT NONE
   CHARACTER  AMONTH*1, ADAY*2, AHR*2, AMIN*2
   INTEGER*2 IMONTH,IDAY,IYEAR
!...GET CURRENT DATE/TIME
   CALL GETDAT(IYEAR,IMONTH,IDAY) 
   CALL GETTIM(IHR,IMIN,ISEC,I100TH)
!...CONVERT MONTH TO HEX CHAR STRING
   IF (IMONTH .LT. 10) THEN
      WRITE (AMONTH,'(I1)') IMONTH
   ELSE IF (IMONTH .EQ. 10) THEN
      AMONTH= 'A'
   ELSE IF (IMONTH .EQ. 11) THEN
      AMONTH= 'B'
   ELSE IF (IMONTH .EQ. 12) THEN
      AMONTH= 'C'
   ENDIF
!...CONVERT DAY TO ZERO-FILLED CHARACTER STRING
   WRITE (ADAY,'(I2)') IDAY
   IF (ADAY(1:1) .EQ. ' ') ADAY(1:1)= '0'
!...CONVERT HOUR TO ZERO-FILLED CHARACTER STRING
   WRITE (AHR,'(I2)') IHR
   IF (AHR(1:1) .EQ. ' ') AHR(1:1)= '0'
!...CONVERT MINUTE TO ZERO-FILLED CHARACTER STRING
   WRITE (AMIN,'(I2)') IMIN
   IF (AMIN(1:1) .EQ. ' ') AMIN(1:1)= '0'
!...CONCATINATE TIME AND DATE INTO A FILE NAME   
   WRITE (AFILE,'(A4,A2,A2,A1,A1,A2)') 'TRAK',AHR,AMIN,'.',AMONTH,ADAY
   WRITE (AFILEBAK,'(A4,A2,A2,A1,A1,A2)') 'BAK_',AHR,AMIN,'.',AMONTH,ADAY
   WRITE (AFILELOG,'(A4,A2,A2,A1,A1,A2)') 'LOG_',AHR,AMIN,'.',AMONTH,ADAY
   OPEN (UNIT=13,FILE=AFILE,STATUS='NEW',ERR=999)
   OPEN (UNIT=14,FILE=AFILEBAK,STATUS='NEW',ERR=999)
   OPEN (UNIT=15,FILE=AFILELOG,STATUS='NEW',ERR=999)
   CLOSE (13)
   CLOSE (14)
   CLOSE (15)
   RETURN
999 CALL OUTTEXT('  WARNING:  UNABLE TO OPEN OUTPUT FILE ')
    CALL OUTTEXT(AFILE)
   RETURN
   ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_HPSPACE()
    USE GRAFTRAK
    IMPLICIT NONE
    OPEN (20,FILE='USER',TITLE='Input hydrophone spacing distance')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Enter distance between hydrophones in meters (-1 to ignore input):'
    READ (20,*,IOSTAT=IERR) HPDIST
    DO WHILE (IERR .NE. 0) 
       WRITE (20,*) 'INVALID ENTRY, Re-enter distance between hydrophones:'
       READ (20,*,IOSTAT=IERR) HPDIST
    ENDDO
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE
    
!.........................................................................................
    SUBROUTINE GET_COMMENT()
    USE GRAFTRAK
    IMPLICIT NONE
    OPEN (20,FILE='USER',TITLE='Input comment')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Enter comment up to 120 characters:'
    READ (20,'(A120)') ACOMMENT
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_OPERATOR()
    USE GRAFTRAK
    IMPLICIT NONE
    OPEN (20,FILE='USER',TITLE='Input operator initials')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Enter initials or other code for acoustician (up to 5 characters):'
    READ (20,*) AOPERATOR
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_BEARING()
    USE GRAFTRAK
    IMPLICIT NONE
    CHARACTER ASTRING*120
    OPEN (20,FILE='USER',TITLE='Input whale bearing from keyboard')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Enter bearing angle from keyboard (-1 to ignore input):'
    READ (20,*,IOSTAT=IERR) WHALBEAR
    DO WHILE ((IERR .NE. 0).OR.(WHALBEAR .LT. -1).OR.(WHALBEAR .GT. 360)) 
       WRITE (20,*) 'INVALID ENTRY, Re-enter bearing angle from keyboard:'
       READ (20,*,IOSTAT=IERR) WHALBEAR
    ENDDO
    WRITE (ABEAR,'(F5.1)') WHALBEAR
    WRITE (ASTRING,'(F5.1)') WHALBEAR
    IF (.NOT. REPLAY) CALL DATAOUT(13,'D',ASTRING)
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_CLICKINTERVAL()
    USE GRAFTRAK
    USE IFQWIN
    IMPLICIT NONE
      CALL GETTIM(IHR,IMIN,ISEC,I100TH)
      CALL GETDAT(IYR,IMO,IDA) 
      CLICKTIME= (IDA*24*60*60)+(IHR*60*60)+(IMIN*60)+ISEC+(I100TH/100.0)
      CLICKINTERVAL= CLICKTIME - LASTCLICKTIME
      WRITE (12,*) CLICKTIME,LASTCLICKTIME,CLICKINTERVAL
      LASTCLICKTIME= CLICKTIME
    RETURN
    ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_NEW_DEADTIME()
    USE GRAFTRAK
    USE IFQWIN
    IMPLICIT NONE
    REAL*8 NEWDEADTIME
    OPEN (20,FILE='USER',TITLE='Input new time to display bearing lines')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Do not display bearing lines older than:'
    WRITE (20,*) '  (enter minutes or -1 to ignore input):'
    READ (20,*,IOSTAT=IERR) NEWDEADTIME
    DO WHILE ((IERR .NE. 0).OR.(NEWDEADTIME .LT. -1)) 
       WRITE (20,*) 'INVALID ENTRY, Re-enter new DEADTIME from keyboard:'
       READ (20,*,IOSTAT=IERR) NEWDEADTIME
    ENDDO
    IF (NEWDEADTIME .GT. 0) DEADTIME= NEWDEADTIME
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_START_END_RECORD()
    USE GRAFTRAK
    USE IFQWIN
    IMPLICIT NONE
    CHARACTER START_OR_END*5, TAPE_NO*5, ELAPSED_TIME*5, ASTRING*120
    OPEN (20,FILE='USER',TITLE='Start or End of Recording')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Input "START" or "END" <comma> Tape# <comma> ElapsedTime hh:mm'
    WRITE (20,*) '  (example:  "START, T103, 10:34"   or  ",,," to ignore)'
    READ (20,'(3A5)',IOSTAT=IERR) START_OR_END, TAPE_NO, ELAPSED_TIME
    DO WHILE (IERR .NE. 0) 
       WRITE (20,*) 'INVALID ENTRY, Re-enter data from keyboard (or ",,," to ignore):'
       READ (20,*,IOSTAT=IERR) START_OR_END, TAPE_NO, ELAPSED_TIME
    ENDDO
    IF (START_OR_END .NE. '') THEN
       WRITE (ASTRING,'(3A5)') START_OR_END, TAPE_NO, ELAPSED_TIME
       IF (.NOT. REPLAY) CALL DATAOUT(13,'r',ASTRING)
    ENDIF
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE

!.........................................................................................
    SUBROUTINE GET_TIMED_UPDATE()
    USE GRAFTRAK
    USE IFQWIN
    IMPLICIT NONE
    CHARACTER UPDATE*5, ASTRING*120
    OPEN (20,FILE='USER',TITLE='Timed Update')
    INPUT_PENDING= .TRUE.
    ISTAT= SETWSIZEQQ(20,winfo2)        
    WRITE (20,*) 'Input codes for what was just heard (up to 5 characters):'
    WRITE (20,*) '  (example:  "DW34" or "," to ignore)'
    READ (20,*,IOSTAT=IERR) UPDATE
    IF (UPDATE .NE. '') THEN
       WRITE (ASTRING,'(A5)') UPDATE
       IF (.NOT. REPLAY) CALL DATAOUT(13,'U',ASTRING)
    ENDIF
    CLOSE (20)
    INPUT_PENDING= .FALSE.
    RETURN
    ENDSUBROUTINE

!THE FOLLOWING IS A TEMPLATE FOR ADDING NEW EVENTS
!.........................................................................................
    SUBROUTINE DUMMY()
    USE GRAFTRAK
    USE IFQWIN
    IMPLICIT NONE
    CHARACTER ASTRING*120
    IF (.NOT. REPLAY) CALL DATAOUT(13,'A',ASTRING)
    RETURN
    ENDSUBROUTINE

